(*| 23:15 25/08/1996 *)
PROGRAM Checks;

USES
  Dos,InfoObj;

CONST
  Verbose:Boolean = False;
  CheckDriveChar:Char = ' ';
  Value: LongInt = 0;
  ExitCode:Word = 0;

  EMS_INT = $67;

VAR
  XLong: LongInt;

PROCEDURE UpperString(VAR S: String);
VAR
  I: Integer;
BEGIN
  FOR I := 1 TO Length(S) DO
    S[I] := UpCase(S[I]);
END;  { UpperString }

PROCEDURE ShowHelp;
BEGIN
  IF NOT Verbose THEN
    Writeln('Checks Program by B Whitnall, v1.0');
  Writeln(' Usage : CHECKS [XMS][EMS][EXT][MEM][CPU][drive:] [/V]');
  Writeln('           each option may be preceded by a minumum value');
  Writeln('           XMS memory in kbytes');
  Writeln('           EMS memory in kbytes');
  Writeln('           EXT memory in kbytes');
  Writeln('           MEM conventional memory in bytes');
  Writeln('           drive space in bytes');
  Writeln('           CPU in [86,286,386,486,586,686]');
  Writeln('           /V verbose mode');
  Writeln('           ?, /?, /H this help info');
  HALT(1);
END;  { ShowHelp }

PROCEDURE ProcessOptions;
VAR
  I: Integer;
  S: String;
BEGIN
  IF ParamCount > 0 THEN FOR I := 1 TO ParamCount DO BEGIN
    S := ParamStr(I);
    IF (Length(S) = 2) AND (S[1] = '/') THEN CASE UpCase(S[2]) OF
      'V' : Verbose := True;
      '?',
      'H' : ShowHelp;
    ELSE
      IF Verbose THEN
        Writeln('Unknown option ',S);
    END;
  END;
END;  { ProcessOptions }

PROCEDURE CheckDriveSpace(Drive: Char);
VAR
  Regs,Regs2: Registers;
  DriveSpace,DriveCapacity: LongInt;
  LIAX,LIBX,LICX,LIDX: LongInt;
BEGIN
  WITH Regs DO BEGIN
    AH := $36;
    IF Drive < 'A' THEN BEGIN
      DL := 0;
      WITH Regs2 DO BEGIN
        AH:=$19;
        MsDos(Regs2);
        Drive := CHR(AL + $41);
      END;
    END ELSE
      DL := ORD(Drive) - $40;
    MsDos(Regs);
    IF AX = $FFFF THEN BEGIN
      ExitCode := 1;
      IF Verbose THEN
        Writeln('Drive ',Drive,': invalid');
    END ELSE BEGIN
      LIAX := AX;
      LIBX := BX;
      LICX := CX;
      LIDX := DX;
      DriveSpace := LIAX*LIBX*LICX;
      DriveCapacity := LIAX*LICX*LIDX;
      IF Verbose THEN
        Writeln('Drive ',Drive,': ',DriveSpace,' bytes free out of ',
                 DriveCapacity);
      IF (Value <> 0) AND (DriveSpace < Value) THEN
        ExitCode := 1;
    END;
  END;
  Value := 0;
END;  { CheckDriveSpace }

PROCEDURE CheckEmsMem;

VAR
  Regs: Registers;
  EMSPages,EMSFreePages: LongInt;
  EMSSpace: LongInt;

  function EmsInst : boolean;

  type EmmName  = array [1..8] of char;   { Name the EMM in driver header }
       EmmNaPtr = ^EmmName;           { Pointer to name in driver header  }

  const Name : EmmName = 'EMMXXXX0';                 { Name of EMS driver }

  begin
    Regs.ax := $35 shl 8 + EMS_INT;          { over interrupt vector 67H }
    msdos( Regs );                                 {Get DOS function 35H }

    EmsInst := (EmmNaPtr(Ptr(Regs.ES,10))^ = Name); {Driver name compare }
  end;

BEGIN
  IF NOT EmsInst THEN
    ExitCode := 1
  ELSE WITH Regs DO BEGIN
    AH := $42;
    Intr(EMS_INT, Regs);
    IF AH <> 0 THEN
      ExitCode := AH
    ELSE BEGIN
      EMSFreePages := BX;
      EMSPages := DX;
      IF Verbose THEN
        Writeln(EMSPages,' (',EMSPages SHL 4,' kbyte) pages of EMS, ',
                EMSFreePages,' (',EMSFreePages SHL 4,' kbyte) pages free');
      IF (Value <> 0) AND (EMSFreePages SHL 4 < Value) THEN
        ExitCode := 1;
    END;
  END;
END;  { CheckEmsMem }

PROCEDURE CheckXmsMem;
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$4300;
    AltIntr($2F, Regs);
    IF AL <> $80 THEN
      ExitCode := 1
    ELSE BEGIN
      AX:=$4310;
      AltIntr($2F, Regs);
      XLong:=LongInt(ES) SHL 16 + BX;
      AX:=$0800;
      longcall(xlong, Regs);
      IF (Value <> 0) AND (AX < Value) THEN
        ExitCode := 1;
      IF Verbose THEN
        Writeln(DX,' kbytes of XMS memory, ',AX,' kbytes free');
    END;
  END;
END;  { CheckXmsMem }

PROCEDURE CheckExtMem;
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AH := $88;
    Intr($15,Regs);
    IF AX = 0 THEN
      ExitCode := 1
    ELSE IF (Value <> 0) AND (AX < Value) THEN
      ExitCode := 1;
    IF Verbose THEN
      Writeln(AX,' kbytes of extended memory');
  END;
END;  { CheckExtMem }

PROCEDURE CheckMem;
VAR
  Regs: Registers;
  DosMem, FreeMem: LongInt;
BEGIN
  Intr($12, Regs);
  DosMem := LongInt(Regs.AX) SHL 10;
  FreeMem := DosMem  - LongInt(PrefixSeg) SHL 4;
  IF (Value <> 0) AND (FreeMem < Value) THEN
    ExitCode := 1;
  IF Verbose THEN
    Writeln(DosMem,' (',DosMem DIV 1024,'k) bytes of conventionial memory, ',
            FreeMem,' (',FreeMem DIV 1024,'k) bytes free');
END;  { CheckMem }

PROCEDURE CheckCpu;
VAR
  cpu_info: cpu_info_t;
  Cpu_Number: Integer;
BEGIN
  WITH cpu_info DO BEGIN
    test_type := 'C';
    CPUID(cpu_info);
    CASE cpu_type OF
      10: Cpu_Number := 686;
      9 : Cpu_Number := 586;
      8 : Cpu_Number := 486;
      7 : Cpu_Number := 386;
      6 : Cpu_Number := 286;
      ELSE Cpu_Number := 86;
    END;
    IF (Value <> 0) AND (Cpu_Number < Value) THEN
      ExitCode := 1;
    IF Verbose THEN BEGIN
      CASE cpu_type OF
        0 : Write('8088');
        1 : Write('8086');
        2 : Write('V20');
        3 : Write('V30');
        4 : Write('80188');
        5 : Write('80186');
        6 : Write('80286');
        7 : Write('80386');
        8 : Write('80486');
        9 : Write('Pentium');
        10: Write('Pentium Pro');
        ELSE Write('Unknown ',cpu_type);
      END;
      Writeln(' CPU');
    END;
  END;
END;  { CheckCpu }

PROCEDURE ProcessCommands;
VAR
  LI: LongInt;
  I,R: Integer;
  S: String;
BEGIN
  IF ParamCount > 0 THEN BEGIN
    FOR I := 1 TO ParamCount DO BEGIN
      S := ParamStr(I);
      IF NOT ((Length(S)=2) AND (S[1]='/')) THEN BEGIN
        UpperString(S);
        VAL(S,LI,R);
        IF R = 0 THEN
          Value := LI
        ELSE IF S = '?' THEN
          ShowHelp
        ELSE IF (Length(S) = 2) AND (S[2] = ':') THEN
          CheckDriveSpace(S[1])
        ELSE IF S = 'EXT' THEN
          CheckExtMem
        ELSE IF S = 'EMS' THEN
          CheckEmsMem
        ELSE IF S = 'XMS' THEN
          CheckXmsMem
        ELSE IF S = 'MEM' THEN
          CheckMem
        ELSE IF S = 'CPU' THEN
          CheckCpu
        ELSE IF Verbose THEN
          Writeln('Unknown command ',S);
      END;
    END;
  END;
END;  { ProcessCommands }

BEGIN
  IF ParamCount = 0 THEN
    ShowHelp;
  ProcessOptions;
  IF Verbose THEN
    Writeln('Checks Program by B Whitnall, v1.0');
  ProcessCommands;
  IF Verbose AND (ExitCode <> 0) THEN
    Writeln('Error, code ',ExitCode);
  HALT(ExitCode);
END.
